libname q 'c:/SASCodeforBook/SASDataSets';
data first; set q.humandevelopment; 

	/*This syntax makes the standard HDIRank Runs Replicating the Chapter's Table 7.4 and 7.5*/

	/*These runs weight the country by the square root of its population*/

Sqrtpop = sqrt(populat);

	/*this code makes the corruption typology*/
coruptyp = .;
	if 1 le corrupt < 3 then coruptyp = 4;
	if 3 le corrupt le 3.3 then coruptyp = 3;
	if 3.4 le corrupt le 5 then coruptyp = 2;
	if 5.01 le corrupt le 11 then coruptyp = 1;

	/*this code makes the freedom typology*/
Fretyp99 = . ;
	if free399 = 'F' then fretyp99 = 1;
	if free399 = 'P' or free399 = 'PF' then fretyp99 = 2;
	if free399 = 'NF' then fretyp99 = 3; 

	/*The following code can be ignored, it presents my method of simulating the effect of class statement
	on missing data.  s stands for signal. This code will produce a flat file of 138 countries*/
sregion = .;
	if region = '01e' or region = '01m' or region = '01n' or region = '01s' or 
	region = '01w' then sregion = 1;
	if region = '02' then sregion = 1;
	if region = '03c' or region = '03ca' or region = '03sa' or region = '04e' or
	region = '04sc' or region = '04se' or region = '04w' then sregion = 1;
	if region = '05e' or region = '05n' or region = '05s' or region = '05w' then sregion = 1;
	if region = '06' then sregion = 1; 

sculture = .;
	if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
	or culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
	culture = 'western' then sculture = 1;

sfretyp9 = .;
	if fretyp99 ne . then sfretyp9 = 1;

sdebt = .;
	if debt ne . then sdebt = 1;

sconflic = .;
	if conflict ne . then sconflic = 1;

scorupt = .;
	if coruptyp ne . then scorupt = 1;
    
sslave = .;
	if slave98 ne . then sslave = 1;
 
fulslave = .;
	if (slavery  ne . or slavery ne 0) then fulslave = 1;

shdirank = .;
	if hdirank ne . then shdirank = 1;

		/*signal=1 will eliminate countries that have some missing data*/

signal = scorupt * sconflic * sdebt * sfretyp9 * sculture * sregion *sslave * shdirank;
run;

	   /* This code creates the working dataset explore that has 138 cases.  The revhdi
	variable reverses the ranking of the human development scale so that higher scores indicate
	poorer human development*/
data explore; set first;
	if signal = 1;  *there will be 138 cases;
	revhdi = 183-hdirank;

	/* This code dichotomizes the cultures as similar to the west (LikeWest = 1) or not (0)*/

LikeWest = .;
	if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
	then LikeWest = 0;
	If culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
	culture = 'western' then likewest = 1;

	/*These codes dichotomize the instrumental freedom prerequisites as zero one indicators*/
lodebt = 1;
	if debt = 2 then lodebt = 0;
	if debt = . then lodebt = .;

dichofre = 0;
	if fretyp99 = 1 then dichofre = 1;
	if fretyp99 = . then dichofre = .;

integrit = 0;
	if coruptyp = 1 then integrit =1;
	if coruptyp = . then integrit = .;

emancip = . ;
	if slavery = 3 or slavery = 4 then emancip = 0;
	if slavery = 1 or slavery = 2 then emancip = 1;

nochaos = 1;
	if conflict = . then nochaos = .;
	if conflict > 0 then nochaos = 0;

	/* This code creates a summary index of instrumental freedoms*/

instfree = dichofre + integrit + emancip +lodebt + nochaos;
run;
Data Explore; Set Explore;

	/*Table 7.4 relates the index of intstrumental factors (instfree) to the HDI rank reversed
	(revHDI), HDI scores (HDIIndex), Longevity Scores (LifIndex), Literacy Scores (EduIndex),
	GDP per Capita (GDPIndex), weighted by the square root of a country's population, and not
	weighted by the square root of a country's population.*/ 

Title '7.4 Effects of Instrumental Freedom Index on Human Development Indicators,
	Weighted by population';
proc corr;
	var instfree revHDI HDIIndex Lifindex EduIndex GDPIndex;
	weight sqrtpop;
run; 

Title'7.4 Effects of Instrumental Freedom Index on Human Development Indicators,
	Not Weighted by population';
proc corr;
	var instfree revHDI HDIIndex Lifindex EduIndex GDPIndex;
run; 

Data Explore; Set Explore;

	/* This code creates the standard deviations for each response variable: 
	revHDI HDIIndex Lifindex EduIndex GDPIndex.  The data are weighted*/

Title 'Table 7.5, Standard Deviations for Calculation of Effect Sizes';
Proc means std;
	Var revHDI HDIIndex Lifindex EduIndex GDPIndex;
	Weight sqrtpop;
Run;


	/* Table 7.5 probes the effects of the dichotomized instrumental factors on reversed HDI rank
	(RevHDI), the HDI scores (HDIIndex), the Longevity Scores (LifIndex), Literacy Scores 
	(EduIndex), and Gross Domestic Product per Capita (GDPIndex)*/
	/* s is an appreviation for solution*/
	/* the parms/nobound statement implements a likelihood ratio test of the between-region
		variance and changes the bounds on the confidence intervals for the variance components*/
	/* In these runs region and culture are the only class variables*/
	/* In these runs the dichotomized instrumental variables are coded zero and one*/

Data Explore; Set Explore;

Title '7.5 Model 1, reversed HDI Ranking (HDIrev), Mixed weighted, no nesting';
proc mixed covtest ratio  cl=wald ;
	class  region culture;
	model revHDI = culture emancip dichofre lodebt nochaos integrit /solution ;
	random region/solution; 
	weight sqrtpop;
	parms/nobound;
run;

Title '7.5 Model 2, HDI Scores (HDIIndex), Mixed weighted, no nesting';
proc mixed covtest ratio  cl=wald ;
	class  region culture nochaos;
	model HDIIndex = culture emancip dichofre lodebt nochaos integrit /solution ;
	random region /solution; 
	weight sqrtpop;
	parms/nobound;
run;

Title '7.5 Model 3, Longevity Scores (LifIndex), Mixed weighted, no nesting';
proc mixed covtest ratio  cl=wald ;
	class  region culture ;
	model LifIndex = culture emancip dichofre lodebt nochaos integrit /solution ;
	random region/solution; 
	weight sqrtpop;
	parms/nobound;
run;

Title '7.5 Model 4, Literacy Scores (EduIndex), Mixed weighted, no nesting';
proc mixed covtest ratio  cl=wald ;
	class  region culture ;
	model EduIndex = culture emancip dichofre lodebt nochaos integrit /solution ;
	random region/solution; 
	weight sqrtpop;
	parms/nobound;
run;

Title '7.5 Model 5, Gross Demestic Product (GDPIndex), Mixed weighted, no nesting';
proc mixed covtest ratio  cl=wald ;
	class  region culture ;
	model GDPIndex = culture emancip dichofre lodebt nochaos integrit /solution ;
	random region/solution; 
	weight sqrtpop;
	parms/nobound;
run;  

				/* Except for the Bonferroni estimates, the code for Tables 7.4 and 7.5 is now complete*/

				/* To calculate the Bonferroni estimates use syntax PMultestTable7.5*/

				/* The syntax in this file is copyright by Robert B. Smith 	 2011. */










































		





































